<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1.5rem; flex-wrap: wrap; gap: 1rem;">
    <div>
        <h1 style="font-weight: 800; color: var(--secondary);">User Management</h1>
        <p style="color: var(--slate); font-size: 0.95rem;">Internal accounts and access control.</p>
    </div>
    
    <div style="display: flex; gap: 1rem; align-items: center;">
        <?php if ($_SESSION['role'] === 'super_admin'): ?>
            <form action="" method="GET" id="filter-form" style="display: flex; align-items: center; gap: 0.5rem;">
                <input type="hidden" name="route" value="user_list">
                <input type="hidden" name="status" value="<?php echo $currentStatus; ?>">
                <select name="company_id" onchange="document.getElementById('filter-form').submit()" style="padding: 0.5rem; border-radius: 6px; border: 1px solid var(--border); background: var(--white); font-size: 0.9rem;">
                    <option value="">All Companies</option>
                    <?php foreach ($companies as $comp): ?>
                        <option value="<?php echo $comp['id']; ?>" <?php echo (isset($currentFilter) && $currentFilter == $comp['id']) ? 'selected' : ''; ?>>
                            <?php echo $comp['name']; ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </form>
        <?php endif; ?>
        <a href="?route=user_create<?php echo !empty($currentFilter) ? '&company_id='.$currentFilter : ''; ?>" class="btn btn-primary">+ Create New User</a>
    </div>
</div>

<!-- Status Tabs -->
<div style="display: flex; gap: 2rem; margin-bottom: 2rem; border-bottom: 2px solid var(--border);">
    <a href="?route=user_list&status=active<?php echo !empty($currentFilter) ? '&company_id='.$currentFilter : ''; ?>" 
       style="padding: 0.75rem 0; text-decoration: none; color: <?php echo $currentStatus === 'active' ? 'var(--primary)' : 'var(--slate)'; ?>; font-weight: 700; border-bottom: 3px solid <?php echo $currentStatus === 'active' ? 'var(--primary)' : 'transparent'; ?>; margin-bottom: -2px; transition: all 0.2s;">
       <i class="fa-solid fa-user-check"></i> Active Accounts
    </a>
    <a href="?route=user_list&status=suspended<?php echo !empty($currentFilter) ? '&company_id='.$currentFilter : ''; ?>" 
       style="padding: 0.75rem 0; text-decoration: none; color: <?php echo $currentStatus === 'suspended' ? 'var(--primary)' : 'var(--slate)'; ?>; font-weight: 700; border-bottom: 3px solid <?php echo $currentStatus === 'suspended' ? 'var(--primary)' : 'transparent'; ?>; margin-bottom: -2px; transition: all 0.2s;">
       <i class="fa-solid fa-user-slash"></i> Suspended
    </a>
</div>

<div class="card" style="border: none; box-shadow: var(--shadow-md); padding: 0;">
    <table style="width: 100%; border-collapse: collapse;">
        <thead>
            <tr style="text-align: left; border-bottom: 2px solid var(--border);">
                <th style="padding: 1rem;">Name</th>
                <th style="padding: 1rem;">Email</th>
                <th style="padding: 1rem;">Company</th>
                <th style="padding: 1rem;">Role</th>
                <th style="padding: 1rem;">Status</th>
                <th style="padding: 1rem;">Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($users as $user): ?>
            <tr style="border-bottom: 1px solid #eee;">
                <td style="padding: 1rem; font-weight: 600;"><?php echo $user['name']; ?></td>
                <td style="padding: 1rem; color: var(--slate);"><?php echo $user['email']; ?></td>
                <td style="padding: 1rem; color: var(--slate); font-size: 0.9rem;"><?php echo $user['company_name'] ?? 'Platform'; ?></td>
                <td style="padding: 1rem;">
                    <?php 
                        $roleIcons = [
                            'super_admin' => 'fa-shield-halved',
                            'company_admin' => 'fa-user-tie',
                            'company_operator' => 'fa-helmet-safety'
                        ];
                    ?>
                    <i class="fa-solid <?php echo $roleIcons[$user['role']] ?? 'fa-user'; ?>" title="<?php echo str_replace('_', ' ', $user['role']); ?>" style="color: var(--primary); font-size: 1.1rem;"></i>
                </td>
                <td style="padding: 1rem;">
                    <i class="fa-solid fa-circle" style="color: <?php echo $user['status'] === 'active' ? 'var(--accent)' : '#e74c3c'; ?>; font-size: 0.8rem;" title="<?php echo ucfirst($user['status']); ?>"></i>
                </td>
                <td style="padding: 1rem; display: flex; gap: 0.5rem;">
                    <a href="?route=user_edit&id=<?php echo $user['id']; ?>" class="action-btn action-btn-edit" title="Edit User">
                        <i class="fa-solid fa-pen-to-square"></i>
                    </a>
                    <?php if ($user['status'] === 'active'): ?>
                        <a href="?route=user_suspend&id=<?php echo $user['id']; ?>&status=suspended<?php echo !empty($currentFilter) ? '&company_id='.$currentFilter : ''; ?>" class="action-btn action-btn-delete" title="Suspend User" onclick="return confirm('Suspend this user?')">
                            <i class="fa-solid fa-user-slash"></i>
                        </a>
                    <?php else: ?>
                        <a href="?route=user_suspend&id=<?php echo $user['id']; ?>&status=active<?php echo !empty($currentFilter) ? '&company_id='.$currentFilter : ''; ?>" class="action-btn" style="background: #e1fdec; color: #10b981;" title="Activate User" onclick="return confirm('Reactivate this user?')">
                            <i class="fa-solid fa-user-check"></i>
                        </a>
                    <?php endif; ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
