<h1><?php echo isset($user) ? 'Edit User' : 'Create New User'; ?></h1>

<div class="card" style="margin-top: 2rem;">
    <form action="?route=user_save" method="POST" style="display: flex; flex-direction: column; gap: 1.5rem;">
        <?php if (isset($user)): ?>
            <input type="hidden" name="id" value="<?php echo $user['id']; ?>">
        <?php endif; ?>

        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1.5rem;">
            <div>
                <label>Full Name</label>
                <input type="text" name="name" value="<?php echo $user['name'] ?? ''; ?>" required>
            </div>
            <div>
                <label>Email Address</label>
                <input type="email" name="email" value="<?php echo $user['email'] ?? ''; ?>" required>
            </div>
        </div>

        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1.5rem;">
            <div>
                <label>User Role</label>
                <?php if ($_SESSION['role'] == 'super_admin'): ?>
                    <select name="role" required>
                        <option value="company_admin" <?php echo (isset($user) && $user['role'] == 'company_admin') ? 'selected' : ''; ?>>Company Admin</option>
                        <option value="company_operator" <?php echo (isset($user) && $user['role'] == 'company_operator') ? 'selected' : ''; ?>>Company Operator</option>
                        <option value="super_admin" <?php echo (isset($user) && $user['role'] == 'super_admin') ? 'selected' : ''; ?>>Super Admin</option>
                    </select>
                <?php else: ?>
                    <input type="text" value="Company Operator" readonly style="background: var(--light-bg); cursor: not-allowed; font-weight: 600;">
                    <input type="hidden" name="role" value="company_operator">
                <?php endif; ?>
            </div>
            <div>
                <label>Assigned Company</label>
                <?php if ($_SESSION['role'] == 'super_admin'): ?>
                    <?php if (isset($user)): ?>
                        <!-- READ-ONLY when editing - company cannot be changed -->
                        <?php 
                            $assignedCompanyName = 'None (Platform Admin)';
                            foreach ($companies as $comp) {
                                if ($user['company_id'] == $comp['id']) {
                                    $assignedCompanyName = $comp['name'];
                                    break;
                                }
                            }
                        ?>
                        <input type="text" value="<?php echo $assignedCompanyName; ?>" readonly style="background: var(--light-bg); cursor: not-allowed; font-weight: 600; color: var(--secondary);">
                        <input type="hidden" name="company_id" value="<?php echo $user['company_id'] ?? ''; ?>">
                        <p style="font-size: 0.85rem; color: var(--slate); margin-top: 0.5rem;">
                            <i class="fa-solid fa-lock"></i> Company assignment cannot be changed after user creation
                        </p>
                    <?php else: ?>
                        <!-- EDITABLE when creating new user -->
                        <select name="company_id">
                            <option value="">None (Platform Admin)</option>
                            <?php foreach ($companies as $comp): ?>
                                <?php 
                                    $isSelected = (!isset($user) && isset($prefilled_company_id) && $prefilled_company_id == $comp['id']);
                                ?>
                                <option value="<?php echo $comp['id']; ?>" <?php echo $isSelected ? 'selected' : ''; ?>>
                                    <?php echo $comp['name']; ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    <?php endif; ?>
                <?php else: ?>
                    <?php 
                        $compName = 'Your Company';
                        $compId = $_SESSION['company_id'];
                        
                        // Try to find name from prefilled ID if available (e.g. if super admin logic was here, but for company admin we use session)
                        if (!empty($_SESSION['company_name'])) {
                            $compName = $_SESSION['company_name'];
                        }
                    ?>
                    <input type="text" value="<?php echo $compName; ?>" readonly style="background: var(--light-bg); cursor: not-allowed; font-weight: 600; color: var(--secondary);">
                    <input type="hidden" name="company_id" value="<?php echo $compId; ?>">
                <?php endif; ?>
            </div>
        </div>

        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1.5rem;">
            <div>
                <label>Password <?php echo isset($user) ? '(Fill only to change)' : ''; ?></label>
                <input type="password" name="password" <?php echo isset($user) ? '' : 'required'; ?>>
            </div>
        </div>

        <div style="display: flex; gap: 1rem; margin-top: 1rem;">
            <button type="submit" class="btn btn-primary">Save User Account</button>
            <a href="?route=user_list" class="btn" style="background: var(--light-bg); border: 1px solid var(--border); text-decoration: none; color: var(--slate);">Cancel</a>
        </div>
    </form>
</div>
