<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 2rem;">
    <div>
        <h1 style="font-weight: 800; color: var(--secondary);">System Overview</h1>
        <p style="color: var(--slate); font-size: 0.95rem;">Platform health and management console.</p>
    </div>
    <div style="display: flex; gap: 0.75rem;">
        <a href="?route=company_list" class="btn btn-secondary"><i class="fa-solid fa-building"></i> Companies</a>
        <a href="?route=user_list" class="btn btn-primary"><i class="fa-solid fa-user-plus"></i> New User</a>
    </div>
</div>

<div class="grid" style="display: grid; grid-template-columns: repeat(3, 1fr); gap: 1rem; margin-bottom: 2rem;">
    <div class="card" style="border: none; position: relative; overflow: hidden; padding: 1rem;">
        <div style="position: absolute; top:0; left:0; width:4px; height:100%; background: var(--primary);"></div>
        <h5 style="color: var(--slate); font-size: 0.65rem; letter-spacing: 1px; font-weight: 700; margin-bottom: 0.5rem;">TOTAL COMPANIES</h5>
        <div style="display: flex; align-items: baseline; gap: 0.5rem;">
            <h2 style="font-size: 1.5rem; font-weight: 800; color: var(--secondary);"><?php echo $stats['companies']; ?></h2>
            <span style="color: var(--accent); font-size: 0.75rem; font-weight: 700; background: rgba(16, 185, 129, 0.1); padding: 1px 6px; border-radius: 20px;">Live</span>
        </div>
    </div>
    <div class="card" style="border: none; padding: 1rem; position: relative; overflow: hidden;">
        <div style="position: absolute; top:0; left:0; width:4px; height:100%; background: var(--accent);"></div>
        <h5 style="color: var(--slate); font-size: 0.65rem; letter-spacing: 1px; font-weight: 700; margin-bottom: 0.5rem;">ACTIVE USERS</h5>
        <h2 style="font-size: 1.5rem; font-weight: 800; color: var(--secondary);"><?php echo $stats['users']; ?></h2>
    </div>
    <a href="?route=listing_list" style="text-decoration: none; color: inherit;">
        <div class="card" style="border: none; padding: 1rem; position: relative; overflow: hidden; cursor: pointer; transition: transform 0.2s, box-shadow 0.2s;" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='var(--shadow-lg)'" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='var(--shadow-md)'">
            <div style="position: absolute; top:0; left:0; width:4px; height:100%; background: #6366f1;"></div>
            <h5 style="color: var(--slate); font-size: 0.65rem; letter-spacing: 1px; font-weight: 700; margin-bottom: 0.5rem;">TOTAL LISTINGS</h5>
            <div style="display: flex; align-items: center; justify-content: space-between;">
                <h2 style="font-size: 1.5rem; font-weight: 800; color: var(--secondary);"><?php echo $stats['listings']; ?></h2>
                <i class="fa-solid fa-arrow-right" style="color: var(--slate); font-size: 0.9rem;"></i>
            </div>
        </div>
    </a>
</div>

<div style="margin-bottom: 2rem;">
    <h3 style="font-weight: 700; color: var(--secondary); margin-bottom: 1rem;">Management Console</h3>
    <div class="grid" style="display: grid; grid-template-columns: repeat(4, 1fr); gap: 1rem;">
        <a href="?route=company_type_list" style="text-decoration: none; color: inherit;">
            <div class="card" style="border: none; padding: 1.25rem; cursor: pointer; transition: all 0.2s; border-left: 3px solid var(--primary);" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='var(--shadow-lg)';" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='var(--shadow-md)';">
                <i class="fa-solid fa-tags" style="font-size: 1.5rem; color: var(--primary); margin-bottom: 0.5rem;"></i>
                <p style="font-weight: 600; color: var(--secondary); margin: 0;">Company Types</p>
                <p style="font-size: 0.75rem; color: var(--slate); margin-top: 0.25rem;">Business categories</p>
            </div>
        </a>
        <a href="?route=membership_type_list" style="text-decoration: none; color: inherit;">
            <div class="card" style="border: none; padding: 1.25rem; cursor: pointer; transition: all 0.2s; border-left: 3px solid #f59e0b;" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='var(--shadow-lg)';" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='var(--shadow-md)';">
                <i class="fa-solid fa-crown" style="font-size: 1.5rem; color: #f59e0b; margin-bottom: 0.5rem;"></i>
                <p style="font-weight: 600; color: var(--secondary); margin: 0;">Membership Types</p>
                <p style="font-size: 0.75rem; color: var(--slate); margin-top: 0.25rem;">Subscription tiers</p>
            </div>
        </a>
        <a href="?route=product_type_list" style="text-decoration: none; color: inherit;">
            <div class="card" style="border: none; padding: 1.25rem; cursor: pointer; transition: all 0.2s; border-left: 3px solid #6366f1;" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='var(--shadow-lg)';" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='var(--shadow-md)';">
                <i class="fa-solid fa-boxes-stacked" style="font-size: 1.5rem; color: #6366f1; margin-bottom: 0.5rem;"></i>
                <p style="font-weight: 600; color: var(--secondary); margin: 0;">Product Types</p>
                <p style="font-size: 0.75rem; color: var(--slate); margin-top: 0.25rem;">Product categories</p>
            </div>
        </a>
        <a href="?route=brand_list" style="text-decoration: none; color: inherit;">
            <div class="card" style="border: none; padding: 1.25rem; cursor: pointer; transition: all 0.2s; border-left: 3px solid var(--accent);" onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='var(--shadow-lg)';" onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='var(--shadow-md)';">
                <i class="fa-solid fa-copyright" style="font-size: 1.5rem; color: var(--accent); margin-bottom: 0.5rem;"></i>
                <p style="font-weight: 600; color: var(--secondary); margin: 0;">Brand Management</p>
                <p style="font-size: 0.75rem; color: var(--slate); margin-top: 0.25rem;">Product brands</p>
            </div>
        </a>
    </div>
</div>

<div class="card" style="margin-top: 2rem; border: none; box-shadow: var(--shadow-md);">
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1.5rem;">
        <h3>Recent Activity Feed</h3>
        <span id="feed-status" style="font-size: 0.75rem; color: var(--slate);">● Live</span>
    </div>
    <div id="activity-feed" style="display: flex; flex-direction: column; gap: 1rem;">
        <div style="text-align: center; padding: 2rem; color: var(--slate);">Loading activities...</div>
    </div>
</div>

<div class="card" style="margin-top: 2rem; border: none; background: var(--secondary); color: var(--white); box-shadow: var(--shadow-md);">
    <h5 style="color: var(--sidebar-text); font-size: 0.65rem; letter-spacing: 1px; font-weight: 700; margin-bottom: 0.5rem;">SYSTEM STATUS</h5>
    <div style="display: flex; align-items: center; gap: 0.5rem;">
        <div style="width: 8px; height: 8px; background: var(--accent); border-radius: 50%; box-shadow: 0 0 10px var(--accent); animation: pulse 2s infinite;"></div>
        <span style="font-weight: 600; font-size: 1rem;">Operational</span>
    </div>
    <p style="color: var(--sidebar-text); font-size: 0.8rem; margin-top: 0.5rem; margin-bottom: 0;">All systems running smoothly</p>
</div>

<script>
function fetchActivities() {
    fetch('/machinery/api_activities.php')
        .then(response => {
            if (!response.ok) {
                throw new Error('HTTP error! status: ' + response.status);
            }
            return response.json();
        })
        .then(data => {
            const feed = document.getElementById('activity-feed');
            
            // Check if API returned an error
            if (data.error) {
                feed.innerHTML = '<div style="text-align: center; padding: 2rem; color: #e74c3c;">Error: ' + data.error + (data.details ? ' - ' + data.details : '') + '</div>';
                return;
            }
            
            if (data.length === 0) {
                feed.innerHTML = '<div style="text-align: center; padding: 2rem; color: var(--slate);">No recent activity.</div>';
                return;
            }
            
            feed.innerHTML = data.map(item => `
                <div style="display: flex; gap: 1rem; padding: 1.25rem; border: 1px solid var(--border); border-radius: var(--radius); align-items: center; animation: fadeIn 0.5s ease-in; background: var(--white);">
                    <div style="background: var(--light-bg); color: var(--primary); width: 45px; height: 45px; display: flex; align-items: center; justify-content: center; border-radius: 12px; font-size: 1.25rem;">
                        ${item.icon || '🔔'}
                    </div>
                    <div style="flex: 1;">
                        <p style="font-weight: 600; font-size: 0.95rem; color: var(--secondary); margin-bottom: 2px;">${item.action}</p>
                        <p style="color: var(--slate); font-size: 0.85rem;">${item.details}</p>
                    </div>
                    <div style="text-align: right;">
                        <span style="color: var(--slate); font-size: 0.75rem; font-weight: 500;">
                            <i class="fa-regular fa-clock"></i> ${new Date(item.created_at).toLocaleTimeString([], {hour: '2-digit', minute:'2-digit'})}
                        </span>
                    </div>
                </div>
            `).join('');
        })
        .catch(err => {
            console.error('Error fetching activities:', err);
            console.error('Error details:', err.message);
            document.getElementById('activity-feed').innerHTML = '<div style="text-align: center; padding: 2rem; color: #e74c3c;">Failed to load activities. Check console for details.</div>';
        });
}

// Initial fetch
fetchActivities();

// Poll every 5 seconds
// setInterval(fetchActivities, 5000);
</script>

<style>
@keyframes fadeIn {
    from { opacity: 0; transform: translateY(10px); }
    to { opacity: 1; transform: translateY(0); }
}
@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.5; }
}
</style>
