<h1><?php echo isset($type) ? 'Edit Product Category' : 'Add New Product Category'; ?></h1>

<div class="card" style="margin-top: 2rem;">
    <form action="?route=product_type_save" method="POST" style="display: flex; flex-direction: column; gap: 1.5rem;">
        <?php if (isset($type)): ?>
            <input type="hidden" name="id" value="<?php echo $type['id']; ?>">
        <?php endif; ?>

        <div>
            <label style="display: block; margin-bottom: 0.5rem; font-weight: 600;">Category Name</label>
            <input type="text" name="name" value="<?php echo $type['name'] ?? ''; ?>" required placeholder="e.g. Spare Part" style="width: 100%;">
            <small style="color: var(--slate); display: block; margin-top: 0.25rem;">The public name of the product category.</small>
        </div>

        <div>
            <label style="display: block; margin-bottom: 0.5rem; font-weight: 600;">Parent Category (Optional)</label>
            <select name="parent_id" style="width: 100%;">
                <option value="">-- No Parent (Top Level) --</option>
                <?php foreach ($all_categories as $cat): ?>
                    <?php 
                        // Skip itself to prevent circular reference
                        if (isset($type) && $cat['id'] == $type['id']) continue; 
                        
                        $indent = str_repeat('&nbsp;&nbsp;&nbsp;', $cat['depth']);
                        $prefix = $cat['depth'] > 0 ? '↳ ' : '';
                    ?>
                    <option value="<?php echo $cat['id']; ?>" <?php echo (isset($type) && $type['parent_id'] == $cat['id']) ? 'selected' : ''; ?>>
                        <?php echo $indent . $prefix . $cat['name']; ?>
                    </option>
                <?php endforeach; ?>
            </select>
            <small style="color: var(--slate); display: block; margin-top: 0.25rem;">Select if this belongs under another category (e.g. AC under Electrical).</small>
        </div>

        <div>
            <label style="display: block; margin-bottom: 0.5rem; font-weight: 600;">Description & Examples</label>
            <textarea name="description" placeholder="e.g. Replaceable components like Filters, Motors..." style="width: 100%; min-height: 120px;"><?php echo $type['description'] ?? ''; ?></textarea>
            <small style="color: var(--slate); display: block; margin-top: 0.25rem;">Help users understand what belongs in this category.</small>
        </div>

        <div style="display: flex; gap: 1rem; margin-top: 1rem; border-top: 1px solid var(--border); padding-top: 1.5rem;">
            <button type="submit" class="btn btn-primary">Save Category</button>
            <a href="?route=product_type_list" class="btn" style="background: #eee; text-decoration: none; color: #333; line-height: 1.2;">Cancel</a>
        </div>
    </form>
</div>
