<h1><?php echo isset($type) ? 'Edit Membership Type' : 'Add New Membership Type'; ?></h1>

<div class="card" style="margin-top: 2rem;">
    <form action="?route=membership_type_save" method="POST" style="display: flex; flex-direction: column; gap: 1.5rem;">
        <?php if (isset($type)): ?>
            <input type="hidden" name="id" value="<?php echo $type['id']; ?>">
        <?php endif; ?>

        <div>
            <label style="display: block; margin-bottom: 0.5rem; font-weight: 600;">Type Name *</label>
            <input type="text" name="name" value="<?php echo htmlspecialchars($type['name'] ?? ''); ?>" required placeholder="e.g. Gold, Silver, Basic">
            <p style="color: var(--slate); font-size: 0.85rem; margin-top: 0.25rem;">The membership tier name (e.g., Gold, Silver, Basic)</p>
        </div>

        <div>
            <label style="display: block; margin-bottom: 0.5rem; font-weight: 600;">Price (BDT) *</label>
            <input type="number" name="price" step="0.01" value="<?php echo htmlspecialchars($type['price'] ?? '0.00'); ?>" required placeholder="9999.00">
            <p style="color: var(--slate); font-size: 0.85rem; margin-top: 0.25rem;">Monthly or annual subscription price</p>
        </div>

        <div>
            <label style="display: block; margin-bottom: 0.5rem; font-weight: 600;">Description</label>
            <textarea name="description" rows="3" placeholder="Brief description of this membership tier"><?php echo htmlspecialchars($type['description'] ?? ''); ?></textarea>
            <p style="color: var(--slate); font-size: 0.85rem; margin-top: 0.25rem;">A short summary of what this membership includes</p>
        </div>

        <div>
            <label style="display: block; margin-bottom: 0.5rem; font-weight: 600;">Features</label>
            <textarea name="features" rows="4" placeholder="Enter features separated by commas (e.g., Unlimited listings, Priority support, Featured placement)"><?php echo htmlspecialchars($type['features'] ?? ''); ?></textarea>
            <p style="color: var(--slate); font-size: 0.85rem; margin-top: 0.25rem;">List the key features, separated by commas</p>
        </div>

        <div>
            <label style="display: block; margin-bottom: 0.5rem; font-weight: 600;">Category Limit</label>
            <input type="number" name="category_limit" min="1" value="<?php echo htmlspecialchars($type['category_limit'] ?? ''); ?>" placeholder="Leave empty for unlimited">
            <p style="color: var(--slate); font-size: 0.85rem; margin-top: 0.25rem;">Maximum number of product categories allowed (leave empty for unlimited)</p>
        </div>

        <div style="display: flex; gap: 1rem; margin-top: 1rem;">
            <button type="submit" class="btn btn-primary">Save Membership Type</button>
            <a href="?route=membership_type_list" class="btn" style="background: var(--light-bg); border: 1px solid var(--border); text-decoration: none; color: var(--slate);">Cancel</a>
        </div>
    </form>
</div>
