<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 2rem;">
    <div>
        <h1 style="font-weight: 800; color: var(--secondary);">Machinery Inventory</h1>
        <p style="color: var(--slate); font-size: 0.95rem;">Manage your active sales and rental listings.</p>
    </div>
    <div style="display: flex; gap: 0.75rem; align-items: center;">
        <?php if ($_SESSION['role'] === 'super_admin'): ?>
            <form method="GET" action="" style="display: flex; align-items: center; gap: 0.5rem;">
                <input type="hidden" name="route" value="listing_list">
                <select name="company_id" onchange="this.form.submit()" style="padding: 0.5rem; border: 1px solid var(--border); border-radius: 4px; color: var(--secondary); max-width: 200px;">
                    <option value="">Filter by Company</option>
                    <?php foreach ($companies as $comp): ?>
                        <option value="<?php echo $comp['uuid']; ?>" <?php echo ($selected_company === $comp['uuid']) ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($comp['name']); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
                <?php if (!empty($selected_company)): ?>
                    <a href="?route=listing_list" class="btn" style="background: var(--light-bg); padding: 0.5rem 0.75rem; font-size: 0.85rem;" title="Clear Filter">
                        <i class="fa-solid fa-times"></i>
                    </a>
                <?php endif; ?>
            </form>
        <?php endif; ?>
        <a href="?route=listing_create" class="btn btn-primary"><i class="fa-solid fa-plus"></i> Add New Machinery</a>
    </div>
</div>

<div class="card" style="border: none; box-shadow: var(--shadow-md); padding: 0;">
    <div class="table-responsive">
        <table style="width: 100%; border-collapse: collapse;">
            <thead>
                <tr style="text-align: left; color: var(--slate); font-size: 0.85rem; border-bottom: 1px solid var(--border);">
                    <th style="padding: 1.25rem;">Machinery / Model</th>
                    <th style="padding: 1.25rem;">Category</th>
                    <th style="padding: 1.25rem;">Brands</th>
                    <th style="padding: 1.25rem;">Condition</th>
                    <th style="padding: 1.25rem;">Mode</th>
                    <th style="padding: 1.25rem;">Stock (S/R)</th>
                    <th style="padding: 1.25rem; text-align: center;">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($listings)): ?>
                    <tr><td colspan="7" style="padding: 3rem; text-align: center; color: var(--slate);">No machinery found.</td></tr>
                <?php else: ?>
                    <?php foreach ($listings as $l): ?>
                        <tr style="border-bottom: 1px solid var(--light-bg); transition: background 0.2s;">
                            <td style="padding: 1.25rem;">
                                <div style="font-weight: 700; color: var(--secondary); font-size: 0.95rem;"><?php echo htmlspecialchars($l['title']); ?></div>
                                <div style="color: var(--slate); font-size: 0.75rem; font-family: monospace;"><?php echo htmlspecialchars($l['model_name'] ?: 'N/A'); ?></div>
                            </td>
                            <td style="padding: 1.25rem;">
                                <span style="font-size: 0.85rem; color: var(--slate);">
                                    <?php echo \Models\ProductType::getCategoryPath($l['product_type_id'] ?? '', $category_map); ?>
                                </span>
                            </td>
                            <td style="padding: 1.25rem;">
                                <div style="display: flex; gap: 0.25rem; flex-wrap: wrap;">
                                    <?php if (!empty($l['brand_names'])): ?>
                                        <?php foreach (explode(', ', $l['brand_names']) as $brand): ?>
                                            <span style="background: var(--light-bg); color: var(--secondary); font-size: 0.65rem; font-weight: 700; padding: 0.1rem 0.4rem; border-radius: 4px; border: 1px solid var(--border);">
                                                <?php echo htmlspecialchars($brand); ?>
                                            </span>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <span style="color: var(--slate); font-size: 0.75rem;">-</span>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td style="padding: 1.25rem;">
                                <span style="font-size: 0.8rem; text-transform: capitalize; font-weight: 600; color: var(--secondary);"><?php echo $l['condition']; ?></span>
                            </td>
                            <td style="padding: 1.25rem;">
                                <span style="font-size: 0.75rem; text-transform: uppercase; font-weight: 700; color: <?php echo $l['listing_type'] == 'sale' ? 'var(--accent)' : ($l['listing_type'] == 'both' ? 'var(--secondary)' : 'var(--primary)'); ?>">
                                    <?php echo $l['listing_type']; ?>
                                </span>
                            </td>
                            <td style="padding: 1.25rem; font-size: 0.9rem; font-weight: 600; color: var(--secondary);">
                                <?php echo $l['sale_stock_qty']; ?> / <?php echo $l['rental_unit_qty']; ?>
                            </td>
                            <td style="padding: 1.25rem; text-align: center;">
                                <div style="display: flex; gap: 0.5rem; justify-content: center;">
                                    <a href="?route=listing_edit&id=<?php echo $l['id']; ?>" class="action-btn" title="Edit Product">
                                        <i class="fa-solid fa-pen-to-square"></i>
                                    </a>
                                    <a href="?route=listing_delete&id=<?php echo $l['id']; ?>" class="action-btn action-btn-danger" title="Delete Product" onclick="return confirm('Archive this machinery?')">
                                        <i class="fa-solid fa-trash"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    </div>
</div>

<?php if (isset($pagination) && $pagination['total_pages'] > 1): ?>
    <div style="display: flex; justify-content: center; margin-top: 2rem; gap: 0.5rem;">
        <?php 
        $urlParams = $_GET;
        unset($urlParams['page']);
        $baseUrl = '?' . http_build_query($urlParams);
        ?>
        
        <?php if ($pagination['current_page'] > 1): ?>
            <a href="<?php echo $baseUrl . '&page=' . ($pagination['current_page'] - 1); ?>" class="btn" style="background: white; border: 1px solid var(--border); color: var(--secondary);">
                <i class="fa-solid fa-chevron-left"></i> Previous
            </a>
        <?php endif; ?>
        
        <div style="display: flex; gap: 0.25rem;">
            <?php for ($i = 1; $i <= $pagination['total_pages']; $i++): ?>
                <a href="<?php echo $baseUrl . '&page=' . $i; ?>" class="btn" style="<?php echo $i === $pagination['current_page'] ? 'background: var(--primary); color: white;' : 'background: white; border: 1px solid var(--border); color: var(--secondary);'; ?> padding: 0.5rem 1rem;">
                    <?php echo $i; ?>
                </a>
            <?php endfor; ?>
        </div>

        <?php if ($pagination['current_page'] < $pagination['total_pages']): ?>
            <a href="<?php echo $baseUrl . '&page=' . ($pagination['current_page'] + 1); ?>" class="btn" style="background: white; border: 1px solid var(--border); color: var(--secondary);">
                Next <i class="fa-solid fa-chevron-right"></i>
            </a>
        <?php endif; ?>
    </div>
<?php endif; ?>
