<div style="margin: 0 auto; padding-bottom: 4rem;">
    <div style="margin-bottom: 2rem;">
        <h1 style="font-weight: 800; color: var(--secondary);"><?php echo isset($listing) ? 'Edit Product' : 'Add New Product'; ?></h1>
        <p style="color: var(--slate); font-size: 0.95rem;">Enter complete technical and business specifications for your machinery.</p>
    </div>

    <form action="?route=listing_save" method="POST" enctype="multipart/form-data" class="card" style="display: flex; flex-direction: column; gap: 1rem; border: none; box-shadow: var(--shadow-md); padding: 2rem;">
        <?php if (isset($listing)): ?>
            <input type="hidden" name="id" value="<?php echo $listing['id']; ?>">
        <?php endif; ?>

        <?php if ($_SESSION['role'] === 'super_admin'): ?>
            <div style="background: var(--light-bg); padding: 1.5rem; border-radius: var(--radius); border: 1px dashed var(--primary); margin-bottom: 1.5rem;">
                <label style="display: block; margin-bottom: 0.5rem; font-weight: 700; color: var(--primary);">Assign to Company (Super Admin Only)</label>
                <select name="company_id" required style="width: 100%; border-color: var(--primary);">
                    <option value="">-- Select Company Owner --</option>
                    <?php foreach ($companies as $comp): ?>
                        <option value="<?php echo $comp['uuid']; ?>" <?php echo (isset($listing) && $listing['company_id'] === $comp['uuid']) ? 'selected' : ''; ?>>
                            <?php echo $comp['name']; ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
        <?php endif; ?>

        <!-- Form Tabs Navigation -->
        <div class="tabs-nav">
            <button type="button" class="tab-btn active" data-tab="identity">
                <i class="fa-solid fa-tag"></i> Identity
            </button>
            <button type="button" class="tab-btn" data-tab="specs">
                <i class="fa-solid fa-gears"></i> Specifications
            </button>
            <button type="button" class="tab-btn" data-tab="business">
                <i class="fa-solid fa-money-bill-transfer"></i> Business
            </button>
            <button type="button" class="tab-btn" data-tab="warranty">
                <i class="fa-solid fa-shield-halved"></i> Warranty & Status
            </button>
            <button type="button" class="tab-btn" data-tab="media">
                <i class="fa-solid fa-file-video"></i> Media & Docs
            </button>
        </div>

        <!-- TAB CONTENT: Product Identity -->
        <div class="tab-content active" id="identity">
            <div class="form-group">
                <div class="section-header">
                    <h3 class="section-title"><i class="fa-solid fa-tag"></i> Product Identity</h3>
                </div>
                <div class="form-group">
                    <label>Category</label>
                    <select name="product_type_id" required style="width: 100%;">
                        <option value="">-- Select Category --</option>
                        <?php foreach ($categories as $cat): ?>
                            <?php 
                                $indent = str_repeat('&nbsp;&nbsp;&nbsp;', $cat['depth']);
                                $prefix = $cat['depth'] > 0 ? '↳ ' : '';
                            ?>
                            <option value="<?php echo $cat['uuid']; ?>" <?php echo (isset($listing) && $listing['product_type_id'] == $cat['uuid']) ? 'selected' : ''; ?>>
                                <?php echo $indent . $prefix . $cat['name']; ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="grid-2">
                    <div class="form-group">
                        <label>Product Title (SEO Friendly)</label>
                        <input type="text" name="title" value="<?php echo htmlspecialchars($listing['title'] ?? ''); ?>" required placeholder="e.g. Caterpillar 320D Excavator" style="width: 100%;">
                    </div>
                    <div class="form-group">
                        <label>Model Name</label>
                        <input type="text" name="model_name" value="<?php echo htmlspecialchars($listing['model_name'] ?? ''); ?>" placeholder="e.g. GVC-60K" style="width: 100%;">
                    </div>
                </div>
                <div class="form-group">
                    <label>Description</label>
                    <textarea name="description" placeholder="Technical specifications..." style="width: 100%; min-height: 120px;"><?php echo htmlspecialchars($listing['description'] ?? ''); ?></textarea>
                </div>
            </div>
        </div>

        <!-- TAB CONTENT: Specifications & Origin -->
        <div class="tab-content" id="specs">
            <div class="form-group">
                <div class="section-header">
                    <h3 class="section-title"><i class="fa-solid fa-gears"></i> Specifications & Origin</h3>
                </div>
                <div class="grid-2">
                    <div class="form-group">
                        <label>Condition</label>
                        <select name="condition" style="width: 100%;">
                            <option value="new" <?php echo (isset($listing) && $listing['condition'] === 'new') ? 'selected' : ''; ?>>Brand New</option>
                            <option value="used" <?php echo (isset($listing) && $listing['condition'] === 'used') ? 'selected' : ''; ?>>Used</option>
                            <option value="refurbished" <?php echo (isset($listing) && $listing['condition'] === 'refurbished') ? 'selected' : ''; ?>>Refurbished</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Manufacture Year</label>
                        <input type="number" name="manufacture_year" value="<?php echo htmlspecialchars($listing['manufacture_year'] ?? ''); ?>" placeholder="YYYY" style="width: 100%;">
                    </div>
                </div>
                <div class="form-group">
                    <label>Country of Origin</label>
                    <input type="text" name="country_of_origin" value="<?php echo htmlspecialchars($listing['country_of_origin'] ?? ''); ?>" placeholder="e.g. Japan" style="width: 100%;">
                </div>
                <div class="form-group">
                    <label>Brands</label>
                    <div style="max-height: 250px; overflow-y: auto; padding: 1rem; border: 1px solid var(--border); border-radius: var(--radius); background: var(--light-bg);">
                        <div style="display: grid; grid-template-columns: repeat(auto-fill, minmax(130px, 1fr)); gap: 0.75rem;">
                            <?php foreach ($brands as $b): ?>
                                <label style="display: flex; align-items: center; gap: 0.5rem; cursor: pointer; font-size: 0.9rem; margin-bottom: 0;">
                                    <input type="checkbox" name="brands[]" value="<?php echo $b['uuid']; ?>" <?php echo (isset($assigned_brands) && in_array($b['uuid'], $assigned_brands)) ? 'checked' : ''; ?>>
                                    <?php echo $b['name']; ?>
                                </label>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- TAB CONTENT: Business Mode -->
        <div class="tab-content" id="business">
            <div class="form-group">
                <div class="section-header">
                    <h3 class="section-title"><i class="fa-solid fa-money-bill-transfer"></i> Business & Inventory</h3>
                </div>
                <div class="grid-3">
                    <div class="form-group">
                        <label>Listing Mode</label>
                        <select name="listing_type" style="width: 100%;">
                            <option value="sale" <?php echo (isset($listing) && $listing['listing_type'] === 'sale') ? 'selected' : ''; ?>>Sale</option>
                            <option value="rent" <?php echo (isset($listing) && $listing['listing_type'] === 'rent') ? 'selected' : ''; ?>>Rent</option>
                            <option value="both" <?php echo (isset($listing) && $listing['listing_type'] === 'both') ? 'selected' : ''; ?>>Both</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Sale Stock</label>
                        <input type="number" name="sale_stock_qty" value="<?php echo $listing['sale_stock_qty'] ?? 0; ?>" style="width: 100%;">
                    </div>
                    <div class="form-group">
                        <label>Rental Stock</label>
                        <input type="number" name="rental_unit_qty" value="<?php echo $listing['rental_unit_qty'] ?? 0; ?>" style="width: 100%;">
                    </div>
                </div>
                <div class="grid-2">
                    <div class="form-group">
                        <label>Price (USD)</label>
                        <input type="number" name="price" id="product-price" value="<?php echo $listing['price'] ?? ''; ?>" placeholder="0.00" step="0.01" style="width: 100%;">
                    </div>
                    <div class="form-group">
                        <label>Discount Type</label>
                        <select name="discount_type" id="discount-type" style="width: 100%;">
                            <option value="none" <?php echo (isset($listing) && $listing['discount_type'] === 'none') ? 'selected' : ''; ?>>No Discount</option>
                            <option value="percentage" <?php echo (isset($listing) && $listing['discount_type'] === 'percentage') ? 'selected' : ''; ?>>Percentage (%)</option>
                            <option value="fixed" <?php echo (isset($listing) && $listing['discount_type'] === 'fixed') ? 'selected' : ''; ?>>Fixed Amount ($)</option>
                        </select>
                    </div>
                </div>
                <div class="grid-2" id="discount-value-container" style="display: <?php echo (isset($listing) && $listing['discount_type'] !== 'none') ? 'grid' : 'none'; ?>;">
                    <div class="form-group">
                        <label>Discount Value</label>
                        <input type="number" name="discount_value" id="discount-value" value="<?php echo $listing['discount_value'] ?? ''; ?>" placeholder="0.00" step="0.01" style="width: 100%;">
                    </div>
                    <div class="form-group">
                        <label>Final Price (Auto-Calculated)</label>
                        <div id="final-price-display" style="padding: 0.8rem 1rem; background: var(--light-bg); border: 1px solid var(--border); border-radius: var(--radius); font-size: 1.1rem; font-weight: 700; color: var(--primary);">$0.00</div>
                    </div>
                </div>
            </div>
        </div>

        <!-- TAB CONTENT: Warranty & Status -->
        <div class="tab-content" id="warranty">
            <div class="grid-2">
                <div>
                    <div class="section-header">
                        <h3 class="section-title"><i class="fa-solid fa-shield-halved"></i> Warranty</h3>
                    </div>
                    <div class="form-group">
                        <label style="display: flex; align-items: center; gap: 0.5rem; cursor: pointer;">
                            <input type="checkbox" name="warranty_applicable" value="1" <?php echo (!empty($listing['warranty_applicable'])) ? 'checked' : ''; ?>>
                            Applicable
                        </label>
                    </div>
                    <div class="grid-2">
                        <div class="form-group">
                            <label>Type</label>
                            <select name="warranty_type">
                                <option value="none" <?php echo (isset($listing) && $listing['warranty_type'] === 'none') ? 'selected' : ''; ?>>None</option>
                                <option value="manufacturer" <?php echo (isset($listing) && $listing['warranty_type'] === 'manufacturer') ? 'selected' : ''; ?>>Manufacturer</option>
                                <option value="seller" <?php echo (isset($listing) && $listing['warranty_type'] === 'seller') ? 'selected' : ''; ?>>Seller</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label>Duration</label>
                            <div style="display: flex; gap: 0.5rem;">
                                <input type="number" name="warranty_duration_value" value="<?php echo $listing['warranty_duration_value'] ?? ''; ?>" style="width: 80px;">
                                <select name="warranty_duration_unit" style="flex: 1;">
                                    <option value="months">Months</option>
                                    <option value="years">Years</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div>
                    <div class="section-header">
                        <h3 class="section-title"><i class="fa-solid fa-circle-check"></i> Status</h3>
                    </div>
                    <div class="form-group">
                        <label>Public Visibility</label>
                        <label style="display: flex; align-items: center; gap: 0.5rem; cursor: pointer;">
                            <input type="checkbox" name="is_active" value="1" <?php echo (!isset($listing) || !empty($listing['is_active'])) ? 'checked' : ''; ?>>
                            Active on Site
                        </label>
                    </div>
                </div>
            </div>
        </div>

        <!-- TAB CONTENT: Media & Documentation -->
        <div class="tab-content" id="media">
            <div class="form-group">
                <div class="section-header">
                    <h3 class="section-title"><i class="fa-solid fa-images"></i> Product Gallery</h3>
                </div>
                
                <!-- Image Upload -->
                <div class="form-group" style="margin-bottom: 2rem;">
                    <label>Upload Images</label>
                    <div style="border: 2px dashed var(--border); padding: 2rem; text-align: center; border-radius: var(--radius); background: var(--light-bg);">
                        <i class="fa-solid fa-cloud-arrow-up" style="font-size: 2rem; color: var(--primary); margin-bottom: 1rem;"></i>
                        <input type="file" name="images[]" multiple accept="image/*" style="display: block; width: 100%; max-width: 300px; margin: 0 auto;">
                        <small style="color: var(--slate); display: block; margin-top: 0.5rem;">Supported: JPG, PNG, WEBP. You can select multiple files.</small>
                    </div>
                </div>

                <!-- Existing Gallery -->
                <?php if (!empty($images)): ?>
                    <div class="form-group">
                        <label>Current Images</label>
                        <div style="display: grid; grid-template-columns: repeat(auto-fill, minmax(150px, 1fr)); gap: 1rem;">
                            <?php foreach ($images as $img): ?>
                                <div class="card" style="padding: 0; overflow: hidden; position: relative; border: <?php echo $img['is_primary'] ? '2px solid var(--primary)' : '1px solid var(--border)'; ?>;">
                                    <?php if ($img['is_primary']): ?>
                                        <div style="position: absolute; top: 0; left: 0; background: var(--primary); color: white; padding: 0.25rem 0.5rem; font-size: 0.7rem; font-weight: 700;">
                                            Primary
                                        </div>
                                    <?php endif; ?>
                                    <img src="uploads/products/<?php echo $img['image_path']; ?>" style="width: 100%; height: 120px; object-fit: cover;">
                                    <div style="padding: 0.5rem; display: flex; justify-content: space-between; gap: 0.5rem; background: white;">
                                        <?php if (!$img['is_primary']): ?>
                                            <a href="?route=listing_image_primary&id=<?php echo $img['id']; ?>" class="btn" style="padding: 0.25rem 0.5rem; font-size: 0.7rem; background: var(--light-bg);" title="Make Primary">
                                                <i class="fa-solid fa-star"></i>
                                            </a>
                                        <?php else: ?>
                                            <span style="width: 24px;"></span>
                                        <?php endif; ?>
                                        <a href="?route=listing_image_delete&id=<?php echo $img['id']; ?>" class="btn" style="padding: 0.25rem 0.5rem; font-size: 0.7rem; background: #fff5f5; color: #c53030;" onclick="return confirm('Delete this image?')" title="Delete">
                                            <i class="fa-solid fa-trash"></i>
                                        </a>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                <?php endif; ?>

                <div class="section-header" style="margin-top: 2rem;">
                    <h3 class="section-title"><i class="fa-solid fa-file-pdf"></i> Documentation & Video</h3>
                </div>
                <div class="grid-2">
                    <div class="form-group">
                        <label>Specification Document (PDF/DOC)</label>
                        <?php if (isset($listing) && !empty($listing['specification_doc'])): ?>
                            <div style="margin-bottom: 1rem; padding: 0.75rem; background: var(--light-bg); border: 1px solid var(--border); border-radius: var(--radius); display: flex; align-items: center; justify-content: space-between;">
                                <div style="display: flex; align-items: center; gap: 0.5rem;">
                                    <i class="fa-solid fa-file-pdf" style="color: var(--primary); font-size: 1.2rem;"></i>
                                    <span style="font-size: 0.9rem; color: var(--secondary); font-weight: 600;"><?php echo basename($listing['specification_doc']); ?></span>
                                </div>
                                <a href="uploads/specifications/<?php echo $listing['specification_doc']; ?>" target="_blank" class="btn btn-secondary" style="padding: 0.4rem 0.8rem; font-size: 0.85rem;">
                                    <i class="fa-solid fa-download"></i> Download
                                </a>
                            </div>
                            <input type="hidden" name="existing_spec_doc" value="<?php echo $listing['specification_doc']; ?>">
                        <?php endif; ?>
                        <input type="file" name="specification_doc" accept=".pdf,.doc,.docx" style="width: 100%;">
                        <small style="color: var(--slate); display: block; margin-top: 0.5rem;">Upload product specifications (PDF, DOC, DOCX only)</small>
                    </div>
                    <div class="form-group">
                        <label>Product Video Link</label>
                        <input type="text" name="video_link" value="<?php echo htmlspecialchars($listing['video_link'] ?? ''); ?>" placeholder="www.youtube.com/watch?v=... or https://youtu.be/..." style="width: 100%;">
                        <small style="color: var(--slate); display: block; margin-top: 0.5rem;">YouTube, Vimeo, or other video platform URL (with or without https://)</small>
                    </div>
                </div>
            </div>
        </div>

        <div class="form-actions">
            <button type="submit" class="btn btn-primary" style="flex: 2; height: 3.5rem;">Save Specifications</button>
            <a href="?route=listing_list" class="btn" style="flex: 1; background: var(--light-bg); color: var(--slate); text-align: center; line-height: 2.3rem;">Cancel</a>
        </div>
    </form>
</div>

<script>
    document.addEventListener('DOMContentLoaded', () => {
        const tabBtns = document.querySelectorAll('.tab-btn');
        const tabContents = document.querySelectorAll('.tab-content');

        tabBtns.forEach(btn => {
            btn.addEventListener('click', () => {
                const target = btn.getAttribute('data-tab');

                // Update buttons
                tabBtns.forEach(b => b.classList.remove('active'));
                btn.classList.add('active');

                // Update content
                tabContents.forEach(content => {
                    content.classList.remove('active');
                    if (content.id === target) {
                        content.classList.add('active');
                    }
                });
            });
        });

        // Discount and Price Calculation Logic
        const priceInput = document.getElementById('product-price');
        const discountType = document.getElementById('discount-type');
        const discountValue = document.getElementById('discount-value');
        const discountContainer = document.getElementById('discount-value-container');
        const finalPriceDisplay = document.getElementById('final-price-display');

        function updateFinalPrice() {
            const price = parseFloat(priceInput?.value) || 0;
            const type = discountType?.value || 'none';
            const value = parseFloat(discountValue?.value) || 0;
            
            let finalPrice = price;
            if (type === 'percentage' && value > 0) {
                finalPrice = price - (price * value / 100);
            } else if (type === 'fixed' && value > 0) {
                finalPrice = Math.max(0, price - value);
            }
            
            if (finalPriceDisplay) {
                finalPriceDisplay.textContent = '$' + finalPrice.toFixed(2);
                finalPriceDisplay.style.color = (finalPrice < price) ? 'var(--accent)' : 'var(--primary)';
            }
        }

        function toggleDiscountFields() {
            const type = discountType?.value || 'none';
            if (discountContainer) {
                discountContainer.style.display = (type !== 'none') ? 'grid' : 'none';
            }
            updateFinalPrice();
        }

        if (discountType) {
            discountType.addEventListener('change', toggleDiscountFields);
        }
        if (priceInput) {
            priceInput.addEventListener('input', updateFinalPrice);
        }
        if (discountValue) {
            discountValue.addEventListener('input', updateFinalPrice);
        }

        // Initial calculation on page load
        toggleDiscountFields();
    });
</script>
