<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $title ?? APP_NAME; ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="app-container">
        <?php if (isset($_SESSION['user_id'])): ?>
            <div class="sidebar-overlay" id="sidebar-overlay"></div>
            <!-- Sidebar for Logged-in Users -->
            <aside class="sidebar" id="sidebar">
                <div style="margin-bottom: 2rem; text-align: center;">
                    <img src="images/logo.png" alt="M-BDS Logo" style="max-width: 100%; height: auto; max-height: 60px;">
                </div>
                
                <?php if ($_SESSION['role'] == 'super_admin'): ?>
                    <a href="?route=super_admin" class="sidebar-link"><i class="fa-solid fa-chart-line"></i> Dashboard</a>
                    <a href="?route=company_list" class="sidebar-link"><i class="fa-solid fa-building"></i> Companies</a>
                    <a href="?route=company_type_list" class="sidebar-link"><i class="fa-solid fa-tags"></i> Biz Types</a>
                    <a href="?route=membership_type_list" class="sidebar-link"><i class="fa-solid fa-crown"></i> Memberships</a>
                    <a href="?route=product_type_list" class="sidebar-link"><i class="fa-solid fa-box-open"></i> Product Cats</a>
                    <a href="?route=brand_list" class="sidebar-link"><i class="fa-solid fa-copyright"></i> Brands</a>
                    <a href="?route=listing_list" class="sidebar-link"><i class="fa-solid fa-boxes-stacked"></i> All Machinery</a>
                    <a href="?route=user_list" class="sidebar-link"><i class="fa-solid fa-users"></i> All Users</a>
                <?php elseif (in_array($_SESSION['role'], ['company_admin', 'company_operator'])): ?>
                    <?php if ($_SESSION['role'] == 'company_admin'): ?>
                        <a href="?route=company_view&id=<?php echo $_SESSION['company_id']; ?>" class="sidebar-link"><i class="fa-solid fa-gauge-high"></i> Dashboard</a>
                        <a href="?route=user_list" class="sidebar-link"><i class="fa-solid fa-user-group"></i> Team</a>
                    <?php endif; ?>
                    <a href="?route=listing_list" class="sidebar-link"><i class="fa-solid fa-boxes-stacked"></i> My Inventory</a>
                <?php endif; ?>
                
                <a href="?route=logout" class="sidebar-link" style="margin-top: auto; color: #ffab91;"><i class="fa-solid fa-right-from-bracket"></i> Logout</a>
            </aside>
        <?php endif; ?>

        <div class="content-wrapper" style="padding: 0;">
            <?php if (isset($_SESSION['user_id'])): ?>
                <!-- Admin Bolt Style Global Header -->
                <header class="main-header" style="justify-content: space-between;">
                    <div style="display: flex; align-items: center;">
                        <?php if (isset($_SESSION['user_id'])): ?>
                            <button id="sidebar-toggle"><i class="fa-solid fa-bars"></i></button>
                        <?php endif; ?>
                        <div>
                            <span style="color: var(--slate); font-size: 0.85rem; font-weight: 500;" class="hide-mobile">MACHINERY BANGLADESH / </span>
                            <span style="color: var(--secondary); font-weight: 700; font-size: 0.85rem;"><?php echo strtoupper(str_replace('_', ' ', $_GET['route'] ?? 'Dashboard')); ?></span>
                        </div>
                    </div>
                    <div style="display: flex; gap: 1.5rem; align-items: center;">
                        <div style="display: flex; gap: 0.5rem; align-items: center; padding-right: 1.5rem; border-right: 1px solid var(--border);" class="hide-mobile">
                             <i class="fa-solid fa-bell" style="color: var(--slate); cursor: pointer;"></i>
                        </div>
                        <?php if (isset($_SESSION['user_id'])): ?>
                            <div style="display: flex; align-items: center; gap: 0.75rem;">
                                <div style="text-align: right;" class="hide-mobile">
                                    <p style="font-weight: 700; font-size: 0.85rem; color: var(--secondary); line-height: 1;"><?php echo htmlspecialchars($_SESSION['name']); ?></p>
                                    <small style="color: var(--slate); font-size: 0.7rem; font-weight: 600;"><?php echo htmlspecialchars(strtoupper($_SESSION['role'])); ?></small>
                                </div>
                                <div style="width: 36px; height: 36px; background: var(--primary); color: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-weight: 800; font-size: 0.9rem;">
                                    <?php echo htmlspecialchars(strtoupper(substr($_SESSION['name'], 0, 1))); ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </header>
            <?php endif; ?>

            <div class="page-content" style="<?php echo isset($_SESSION['user_id']) ? '' : 'max-width: 1400px; margin: 0 auto;'; ?> padding: 2rem;">
                <?php include __DIR__ . '/../' . $view . '.php'; ?>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const toggle = document.getElementById('sidebar-toggle');
            const sidebar = document.getElementById('sidebar');
            const overlay = document.getElementById('sidebar-overlay');

            if (toggle && sidebar && overlay) {
                toggle.addEventListener('click', () => {
                    sidebar.classList.add('active');
                    overlay.classList.add('active');
                });

                overlay.addEventListener('click', () => {
                    sidebar.classList.remove('active');
                    overlay.classList.remove('active');
                });
            }
        });
    </script>
</body>
</html>
