<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 2rem;">
    <div>
        <h1 style="font-weight: 800;">Business Categories</h1>
        <p style="color: var(--slate);">Define machinery niche types.</p>
    </div>
    <a href="?route=company_type_create" class="btn btn-primary">+ Add New</a>
</div>

<div class="card" style="border: none; box-shadow: var(--shadow-md);">
    <table style="width: 100%; border-collapse: collapse;">
        <thead>
            <tr style="text-align: left; border-bottom: 2px solid var(--border);">
                <th style="padding: 1rem;">Type Name</th>
                <th style="padding: 1rem; text-align: right;">Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($types as $type): ?>
            <tr style="border-bottom: 1px solid #eee;">
                <td style="padding: 1rem; font-weight: 600;"><?php echo $type['name']; ?></td>
                <td style="padding: 1rem; display: flex; gap: 0.5rem; justify-content: flex-end;">
                    <a href="?route=company_type_edit&id=<?php echo $type['id']; ?>" class="action-btn action-btn-edit" title="Edit Category">
                        <i class="fa-solid fa-pen-to-square"></i>
                    </a>
                    <a href="?route=company_type_delete&id=<?php echo $type['id']; ?>" class="action-btn action-btn-delete" title="Delete Category" onclick="return confirm('Delete this type?')">
                        <i class="fa-solid fa-trash-can"></i>
                    </a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
