<?php if (!empty($company['banner'])): ?>
    <div style="width: 100%; height: 200px; margin: -2rem -2rem 2rem -2rem; border-radius: 0; overflow: hidden; position: relative;">
        <img src="uploads/banners/<?php echo htmlspecialchars($company['banner']); ?>" style="width: 100%; height: 100%; object-fit: cover;">
        <div style="position: absolute; bottom: 0; left: 0; right: 0; background: linear-gradient(to top, rgba(0,0,0,0.7), transparent); padding: 2rem; color: white;">
            <h1 style="font-weight: 800; color: white; text-shadow: 2px 2px 4px rgba(0,0,0,0.5);"><?php echo htmlspecialchars($company['name']); ?></h1>
        </div>
    </div>
<?php endif; ?>

<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 2rem; flex-wrap: wrap; gap: 1rem;">
    <div style="display: flex; align-items: center; gap: 1.5rem;">
        <?php if (!empty($company['logo'])): ?>
            <img src="uploads/logos/<?php echo htmlspecialchars($company['logo']); ?>" style="width: 64px; height: 64px; border-radius: 12px; object-fit: cover; border: 1px solid var(--border);">
        <?php else: ?>
            <div style="width: 64px; height: 64px; border-radius: 12px; background: var(--secondary); color: white; display: flex; align-items: center; justify-content: center; font-size: 1.5rem;">
                <i class="fa-solid fa-building"></i>
            </div>
        <?php endif; ?>
        <div>
            <?php if (empty($company['banner'])): ?>
                <h1 style="font-weight: 800; color: var(--secondary);"><?php echo htmlspecialchars($company['name']); ?></h1>
            <?php endif; ?>
            <p style="color: var(--slate); font-size: 0.95rem;">
                <i class="fa-solid fa-location-dot"></i> <?php echo htmlspecialchars($company['address']); ?> | 
                <i class="fa-solid fa-phone"></i> <?php echo htmlspecialchars($company['phone']); ?>
            </p>
        </div>
    </div>
    <div style="display: flex; gap: 0.75rem;">
        <a href="?route=company_edit&id=<?php echo $company['id']; ?>" class="btn btn-secondary">Edit Profile</a>
        <a href="?route=company_list" class="btn" style="background: var(--light-bg); color: var(--slate);">Back to List</a>
    </div>
</div>

<div class="grid-auto" style="margin-bottom: 2rem;">
    <a href="?route=user_list&company_id=<?php echo $company['id']; ?>" class="card" style="border: none; text-decoration: none; cursor: pointer; transition: transform 0.2s; padding: 1rem;">
        <h5 style="color: var(--slate); font-size: 0.65rem; letter-spacing: 1px; font-weight: 700; margin-bottom: 0.5rem;">TOTAL TEAM</h5>
        <div style="display: flex; justify-content: space-between; align-items: baseline;">
            <h2 style="font-size: 1.5rem; font-weight: 800; color: var(--secondary);"><?php echo count($users); ?></h2>
            <i class="fa-solid fa-arrow-right-long" style="color: var(--primary); font-size: 1rem;"></i>
        </div>
    </a>
    <a href="?route=listing_list&company_id=<?php echo $company['uuid']; ?>" class="card" style="border: none; padding: 1rem; text-decoration: none; cursor: pointer; transition: transform 0.2s;">
        <h5 style="color: var(--slate); font-size: 0.65rem; letter-spacing: 1px; font-weight: 700; margin-bottom: 0.5rem;">TOTAL LISTINGS</h5>
        <h2 style="font-size: 1.5rem; font-weight: 800; color: var(--secondary);"><?php echo $stats['total']; ?></h2>
    </a>
    <div class="card" style="border: none; padding: 1rem;">
        <h5 style="color: var(--slate); font-size: 0.65rem; letter-spacing: 1px; font-weight: 700; margin-bottom: 0.5rem;">FOR SALE</h5>
        <h2 style="font-size: 1.5rem; font-weight: 800; color: var(--accent);"><?php echo $stats['sell_count']; ?></h2>
    </div>

</div>

<div class="grid-2">
    <!-- Team Section -->
    <div class="card" style="border: none;">
        <h4 style="margin-bottom: 1.5rem; color: var(--secondary); border-bottom: 2px solid var(--primary-light); padding-bottom: 0.5rem;">Team Members</h4>
        <div style="display: flex; flex-direction: column; gap: 1rem;">
            <?php foreach ($users as $u): ?>
                <div style="display: flex; align-items: center; gap: 1rem; padding: 0.75rem; background: var(--light-bg); border-radius: 8px;">
                    <div style="width: 32px; height: 32px; background: var(--primary); color: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-weight: bold; font-size: 0.8rem;">
                        <?php echo htmlspecialchars(strtoupper(substr($u['name'], 0, 1))); ?>
                    </div>
                    <div style="flex: 1;">
                        <p style="font-weight: 600; font-size: 0.9rem;"><?php echo htmlspecialchars($u['name']); ?></p>
                        <small style="color: var(--slate);"><?php echo htmlspecialchars($u['role']); ?></small>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>

    <!-- Listings Section -->
    <div class="card" style="border: none; padding: 0;">
        <h4 style="margin: 1.5rem; margin-bottom: 1rem; color: var(--secondary); border-bottom: 2px solid var(--primary-light); padding-bottom: 0.5rem;">Machinery Portfolio</h4>
        <div class="table-responsive">
            <table style="width: 100%; border-collapse: collapse;">
                <thead>
                    <tr style="text-align: left; color: var(--slate); font-size: 0.85rem; border-bottom: 1px solid var(--border);">
                        <th style="padding: 0.75rem; width: 60px;">Image</th>
                        <th style="padding: 0.75rem;">Machinery / Model</th>
                        <th style="padding: 0.75rem;">Category</th>
                        <th style="padding: 0.75rem;">Brands</th>
                        <th style="padding: 0.75rem;">Cond.</th>
                        <th style="padding: 0.75rem;">Mode</th>
                        <th style="padding: 0.75rem;">Stock</th>
                        <th style="padding: 0.75rem;">Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($listings)): ?>
                        <tr><td colspan="8" style="padding: 2rem; text-align: center; color: var(--slate);">No listings found.</td></tr>
                    <?php else: ?>
                        <?php foreach ($listings as $l): ?>
                            <tr style="border-bottom: 1px solid var(--light-bg);">
                                <td style="padding: 0.75rem;">
                                    <div style="width: 48px; height: 48px; background: #f0f4f8; border-radius: 4px; overflow: hidden; display: flex; align-items: center; justify-content: center; border: 1px solid var(--border);">
                                        <?php if (!empty($l['primary_image'])): ?>
                                            <img src="uploads/products/<?php echo $l['primary_image']; ?>" style="width: 100%; height: 100%; object-fit: cover;">
                                        <?php else: ?>
                                            <i class="fa-solid fa-image" style="color: var(--slate); opacity: 0.5;"></i>
                                        <?php endif; ?>
                                    </div>
                                </td>
                                <td style="padding: 0.75rem;">
                                    <div style="font-weight: 500; font-size: 0.9rem; color: var(--secondary);"><?php echo htmlspecialchars($l['title']); ?></div>
                                    <div style="font-size: 0.7rem; color: var(--slate); font-family: monospace;"><?php echo htmlspecialchars($l['model_name'] ?: 'N/A'); ?></div>
                                </td>
                                <td style="padding: 0.75rem; font-size: 0.85rem; color: var(--slate);">
                                    <?php echo \Models\ProductType::getCategoryPath($l['product_type_id'] ?? '', $category_map); ?>
                                </td>
                                <td style="padding: 0.75rem;">
                                    <div style="display: flex; gap: 0.25rem; flex-wrap: wrap;">
                                        <?php if (!empty($l['brand_names'])): ?>
                                            <?php foreach (explode(', ', $l['brand_names']) as $brand): ?>
                                                <span style="background: var(--light-bg); color: var(--secondary); font-size: 0.6rem; font-weight: 700; padding: 0.1rem 0.3rem; border-radius: 4px; border: 1px solid var(--border);">
                                                    <?php echo htmlspecialchars($brand); ?>
                                                </span>
                                            <?php endforeach; ?>
                                        <?php else: ?>
                                            <span style="color: var(--slate); font-size: 0.75rem;">-</span>
                                        <?php endif; ?>
                                    </div>
                                </td>
                                <td style="padding: 0.75rem; font-size: 0.8rem; text-transform: capitalize; color: var(--secondary);">
                                    <?php echo htmlspecialchars($l['condition']); ?>
                                </td>
                                <td style="padding: 0.75rem;">
                                    <span style="font-size: 0.7rem; text-transform: uppercase; font-weight: 700; color: <?php echo $l['listing_type'] == 'sale' ? 'var(--accent)' : 'var(--primary)'; ?>">
                                        <?php echo htmlspecialchars($l['listing_type']); ?>
                                    </span>
                                </td>
                                <td style="padding: 0.75rem; font-size: 0.85rem; font-weight: 600;">
                                    <?php echo htmlspecialchars($l['sale_stock_qty']) . '/' . htmlspecialchars($l['rental_unit_qty']); ?>
                                </td>
                                <td style="padding: 0.75rem;">
                                    <span style="font-size: 0.7rem; text-transform: uppercase; font-weight: 700; color: <?php echo $l['status'] == 'active' ? 'var(--accent)' : 'var(--warning)'; ?>">
                                        <?php echo htmlspecialchars(str_replace('_', ' ', $l['status'])); ?>
                                    </span>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php if (isset($pagination) && $pagination['total_pages'] > 1): ?>
    <div style="display: flex; justify-content: center; margin-top: 2rem; gap: 0.5rem;">
        <?php 
        $urlParams = $_GET;
        unset($urlParams['page']);
        $baseUrl = '?' . http_build_query($urlParams);
        ?>
        
        <?php if ($pagination['current_page'] > 1): ?>
            <a href="<?php echo $baseUrl . '&page=' . ($pagination['current_page'] - 1); ?>" class="btn" style="background: white; border: 1px solid var(--border); color: var(--secondary);">
                <i class="fa-solid fa-chevron-left"></i> Previous
            </a>
        <?php endif; ?>
        
        <div style="display: flex; gap: 0.25rem;">
            <?php for ($i = 1; $i <= $pagination['total_pages']; $i++): ?>
                <a href="<?php echo $baseUrl . '&page=' . $i; ?>" class="btn" style="<?php echo $i === $pagination['current_page'] ? 'background: var(--primary); color: white;' : 'background: white; border: 1px solid var(--border); color: var(--secondary);'; ?> padding: 0.5rem 1rem;">
                    <?php echo $i; ?>
                </a>
            <?php endfor; ?>
        </div>

        <?php if ($pagination['current_page'] < $pagination['total_pages']): ?>
            <a href="<?php echo $baseUrl . '&page=' . ($pagination['current_page'] + 1); ?>" class="btn" style="background: white; border: 1px solid var(--border); color: var(--secondary);">
                Next <i class="fa-solid fa-chevron-right"></i>
            </a>
        <?php endif; ?>
    </div>
<?php endif; ?>
