<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 2rem;">
    <div>
        <h1 style="font-weight: 800; color: var(--secondary);">Machinery Brands</h1>
        <p style="color: var(--slate); font-size: 0.95rem;">Manage global equipment manufacturers and brands.</p>
    </div>
    <a href="?route=brand_create" class="btn btn-primary"><i class="fa-solid fa-plus"></i> Add New Brand</a>
</div>

<div class="card" style="border: none; box-shadow: var(--shadow-md); padding: 0;">
    <table style="width: 100%; border-collapse: collapse;">
        <thead>
            <tr style="text-align: left; background: var(--light-bg); color: var(--secondary); font-size: 0.85rem; text-transform: uppercase; letter-spacing: 0.5px;">
                <th style="padding: 1.25rem;">Brand / Slug</th>
                <th style="padding: 1.25rem;">Origin</th>
                <th style="padding: 1.25rem;">Description</th>
                <th style="padding: 1.25rem; text-align: center;">Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($brands as $b): ?>
                <tr style="border-bottom: 1px solid var(--border); transition: background 0.2s;">
                    <td style="padding: 1.25rem;">
                        <div style="display: flex; align-items: center; gap: 1rem;">
                            <?php if (!empty($b['logo'])): ?>
                                <img src="uploads/brands/<?php echo $b['logo']; ?>" style="width: 40px; height: 40px; object-fit: contain; border-radius: 4px; border: 1px solid var(--border);">
                            <?php else: ?>
                                <div style="width: 40px; height: 40px; background: var(--light-bg); color: var(--slate); display: flex; align-items: center; justify-content: center; border-radius: 4px; border: 1px solid var(--border);">
                                    <i class="fa-solid fa-copyright"></i>
                                </div>
                            <?php endif; ?>
                            <div>
                                <span style="font-weight: 700; color: var(--secondary); display: block;"><?php echo $b['name']; ?></span>
                                <small style="color: var(--slate); font-size: 0.7rem; font-family: monospace;">/<?php echo $b['brand_slug']; ?></small>
                            </div>
                        </div>
                    </td>
                    <td style="padding: 1.25rem;">
                        <span style="font-weight: 600; color: var(--secondary); font-size: 0.85rem;"><?php echo $b['country_of_origin'] ?: 'Unknown'; ?></span>
                    </td>
                    <td style="padding: 1.25rem;">
                        <p style="color: var(--slate); font-size: 0.85rem; margin: 0; line-height: 1.4;"><?php echo $b['description'] ?? 'No description provided'; ?></p>
                    </td>
                    <td style="padding: 1.25rem; text-align: center;">
                        <div style="display: flex; gap: 0.5rem; justify-content: center;">
                            <a href="?route=brand_edit&id=<?php echo $b['id']; ?>" class="action-btn" title="Edit">
                                <i class="fa-solid fa-pen-to-square"></i>
                            </a>
                            <a href="?route=brand_delete&id=<?php echo $b['id']; ?>" class="action-btn action-btn-danger" title="Delete" onclick="return confirm('Delete this brand?')">
                                <i class="fa-solid fa-trash"></i>
                            </a>
                        </div>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
