<?php
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/app/Core/Database.php';

try {
    $db = \Core\Database::getInstance();
    
    // 1. Create company_types table
    $db->exec("CREATE TABLE IF NOT EXISTS company_types (
        id INT AUTO_INCREMENT PRIMARY KEY,
        name VARCHAR(100) NOT NULL UNIQUE,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    )");

    // 2. Seed initial types
    $types = ['Manufacturing', 'Garments', 'ELECTRICAL lift', 'Road and bridge'];
    $stmt = $db->prepare("INSERT IGNORE INTO company_types (name) VALUES (?)");
    foreach ($types as $type) {
        $stmt->execute([$type]);
    }

    // 3. Update companies table structure
    // We'll keep the old 'type' for now and add 'company_type_id'
    $db->exec("ALTER TABLE companies ADD COLUMN company_type_id INT AFTER type");
    
    // 4. Link existing data (optional but good for consistency)
    $db->exec("UPDATE companies c JOIN company_types ct ON c.type = ct.name SET c.company_type_id = ct.id");

    echo "Company Type infrastructure created successfully!";
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}
