<?php
require_once __DIR__ . "/config/config.php";
require_once __DIR__ . "/app/Core/Database.php";

use Core\Database;

try {
    $db = Database::getInstance();
    
    // Check if is_active column exists
    $checkColumn = $db->query("SHOW COLUMNS FROM products LIKE 'is_active'");
    
    if ($checkColumn->rowCount() == 0) {
        // Add is_active column back to products table
        $db->exec("ALTER TABLE products ADD COLUMN is_active BOOLEAN DEFAULT TRUE AFTER listing_type");
        echo "✓ Successfully added 'is_active' column back to products table.\n";
    } else {
        echo "ℹ Column 'is_active' already exists in products table. No changes needed.\n";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
