<?php
require_once __DIR__ . "/config/config.php";
require_once __DIR__ . "/app/Core/Database.php";

use Core\Database;

try {
    $db = Database::getInstance();
    
    // Create Products Table
    $db->exec("CREATE TABLE IF NOT EXISTS products (
        id CHAR(36) PRIMARY KEY,
        company_id CHAR(36) NOT NULL,
        product_type_id CHAR(36) NULL,
        category_id CHAR(36) NULL,
        brand_id CHAR(36) NULL,
        
        -- Identity
        model_name VARCHAR(255) NULL,
        title VARCHAR(255) NOT NULL,
        slug VARCHAR(255) UNIQUE NOT NULL,
        description TEXT NULL,
        
        -- Condition & Origin
        `condition` ENUM('new', 'used', 'refurbished') DEFAULT 'new',
        manufacture_year YEAR NULL,
        country_of_origin VARCHAR(100) NULL,
        
        -- Business Mode
        listing_type ENUM('sale', 'rent', 'both') DEFAULT 'sale',
        is_active BOOLEAN DEFAULT TRUE,
        status ENUM('draft', 'pending_approval', 'active', 'suspended', 'archived') DEFAULT 'draft',
        
        -- Warranty
        warranty_applicable BOOLEAN DEFAULT FALSE,
        warranty_type ENUM('manufacturer', 'seller', 'none') DEFAULT 'none',
        warranty_duration_value INT NULL,
        warranty_duration_unit ENUM('months', 'years') NULL,
        
        -- Inventory
        sale_stock_qty INT DEFAULT 0,
        rental_unit_qty INT DEFAULT 0,
        
        -- Logistics
        location_id CHAR(36) NULL,
        delivery_available BOOLEAN DEFAULT FALSE,
        installation_available BOOLEAN DEFAULT FALSE,
        
        -- Audit & Control
        created_by CHAR(36) NOT NULL,
        updated_by CHAR(36) NULL,
        approved_by CHAR(36) NULL,
        approved_at TIMESTAMP NULL,
        
        -- Timestamps
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        deleted_at TIMESTAMP NULL,
        
        -- Foreign Key Constraints
        FOREIGN KEY (company_id) REFERENCES companies(uuid) ON DELETE CASCADE,
        FOREIGN KEY (product_type_id) REFERENCES product_types(uuid) ON DELETE SET NULL,
        FOREIGN KEY (category_id) REFERENCES categories(id) ON DELETE SET NULL,
        FOREIGN KEY (brand_id) REFERENCES brands(uuid) ON DELETE SET NULL,
        FOREIGN KEY (created_by) REFERENCES users(uuid),
        FOREIGN KEY (updated_by) REFERENCES users(uuid),
        FOREIGN KEY (approved_by) REFERENCES users(uuid),
        FOREIGN KEY (location_id) REFERENCES company_locations(id) ON DELETE SET NULL
    )");

    // Pivot table for multi-brands (keeping our existing feature if requested, but list had single brand_id)
    // The user's list has brand_id (singular), but earlier they wanted multiple brands.
    // I'll stick to their NEW list for the products table, but I might keep the pivot table as 'product_brands'
    $db->exec("CREATE TABLE IF NOT EXISTS product_brands (
        product_id CHAR(36) NOT NULL,
        brand_id CHAR(36) NOT NULL,
        PRIMARY KEY (product_id, brand_id),
        FOREIGN KEY (product_id) REFERENCES products(id) ON DELETE CASCADE,
        FOREIGN KEY (brand_id) REFERENCES brands(uuid) ON DELETE CASCADE
    )");

    echo "Products table and relations created successfully.";
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}
