<?php
require_once __DIR__ . "/config/config.php";
require_once __DIR__ . "/app/Core/Database.php";

use Core\Database;

try {
    $db = Database::getInstance();
    $db->exec("CREATE TABLE IF NOT EXISTS product_types (
        id INT AUTO_INCREMENT PRIMARY KEY,
        name VARCHAR(100) NOT NULL UNIQUE,
        description TEXT,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    )");

    // Insert Default Types
    $defaults = [
        ["Machine", "Heavy or light industrial machinery (Excavator, Crane, Generator, Forklift)"],
        ["Attachment / Accessory", "Used with machines (Buckets, Drilling Heads, Blades)"],
        ["Spare Part", "Replaceable components (Filters, Motors, Hydraulic Pipes)"],
        ["Tool / Equipment", "Standalone operational equipment (Welding Machines, Compressors)"]
    ];

    $stmt = $db->prepare("INSERT IGNORE INTO product_types (name, description) VALUES (?, ?)");
    foreach ($defaults as $type) {
        $stmt->execute($type);
    }

    echo "Product Types migrated successfully.";
} catch (PDOException $e) {
    echo "Migration failed: " . $e->getMessage();
} catch (Error $e) {
    echo "Error: " . $e->getMessage();
}
