<?php
require_once __DIR__ . "/config/config.php";
require_once __DIR__ . "/app/Core/Database.php";

use Core\Database;

try {
    $db = Database::getInstance();
    
    echo "Adding product enhancement fields...\n";
    
    // Add price and discount fields
    echo "1. Adding price and discount columns...\n";
    $db->exec("ALTER TABLE products 
        ADD COLUMN IF NOT EXISTS price DECIMAL(12, 2) NULL COMMENT 'Regular price',
        ADD COLUMN IF NOT EXISTS discount_type ENUM('none', 'percentage', 'fixed') DEFAULT 'none' COMMENT 'Discount type',
        ADD COLUMN IF NOT EXISTS discount_value DECIMAL(10, 2) NULL COMMENT 'Discount percentage or fixed amount'
    ");
    
    // Add media and documentation fields
    echo "2. Adding media and documentation columns...\n";
    $db->exec("ALTER TABLE products 
        ADD COLUMN IF NOT EXISTS specification_doc VARCHAR(255) NULL COMMENT 'Path to spec document',
        ADD COLUMN IF NOT EXISTS video_link VARCHAR(500) NULL COMMENT 'YouTube/Vimeo video URL'
    ");
    
    echo "\n✅ Product enhancement fields added successfully!\n";
    echo "\nNew fields added:\n";
    echo "- price (DECIMAL)\n";
    echo "- discount_type (ENUM: none, percentage, fixed)\n";
    echo "- discount_value (DECIMAL)\n";
    echo "- specification_doc (VARCHAR)\n";
    echo "- video_link (VARCHAR)\n";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}
