<?php
// Migration: Add Membership Types System
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/app/Core/Database.php';

try {
    $db = Core\Database::getInstance();
    
    echo "Starting Membership Types Migration...\n\n";
    
    // Step 1: Create membership_types table
    echo "1. Creating membership_types table...\n";
    $db->exec("
        CREATE TABLE IF NOT EXISTS membership_types (
            id INT AUTO_INCREMENT PRIMARY KEY,
            name VARCHAR(100) NOT NULL UNIQUE,
            description TEXT,
            price DECIMAL(10, 2) DEFAULT 0.00,
            features TEXT,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
    ");
    echo "   ✓ membership_types table created\n\n";
    
    // Step 2: Add membership_type_id to companies table
    echo "2. Adding membership_type_id column to companies table...\n";
    $db->exec("
        ALTER TABLE companies 
        ADD COLUMN IF NOT EXISTS membership_type_id INT NULL,
        ADD CONSTRAINT fk_membership_type 
        FOREIGN KEY (membership_type_id) 
        REFERENCES membership_types(id) 
        ON DELETE SET NULL
    ");
    echo "   ✓ Column added to companies table\n\n";
    
    // Step 3: Seed initial membership types
    echo "3. Seeding initial membership types...\n";
    
    // Check if types already exist
    $stmt = $db->query("SELECT COUNT(*) FROM membership_types");
    $count = $stmt->fetchColumn();
    
    if ($count == 0) {
        $types = [
            [
                'name' => 'Gold',
                'description' => 'Premium membership with full access to all features',
                'price' => 9999.00,
                'features' => 'Unlimited listings, Priority support, Featured placement, Analytics dashboard, API access'
            ],
            [
                'name' => 'Silver',
                'description' => 'Standard membership with essential features',
                'price' => 4999.00,
                'features' => 'Up to 50 listings, Email support, Standard placement, Basic analytics'
            ],
            [
                'name' => 'Basic',
                'description' => 'Entry-level membership for small businesses',
                'price' => 1999.00,
                'features' => 'Up to 10 listings, Community support, Standard placement'
            ]
        ];
        
        $stmt = $db->prepare("
            INSERT INTO membership_types (name, description, price, features) 
            VALUES (?, ?, ?, ?)
        ");
        
        foreach ($types as $type) {
            $stmt->execute([
                $type['name'],
                $type['description'],
                $type['price'],
                $type['features']
            ]);
            echo "   ✓ Created: {$type['name']} membership\n";
        }
    } else {
        echo "   ⚠ Membership types already exist, skipping seed\n";
    }
    
    echo "\n✅ Migration completed successfully!\n";
    echo "\nNext steps:\n";
    echo "- Access the membership types management at: ?route=membership_type_list\n";
    echo "- Assign membership types to companies in the company form\n";
    
} catch (PDOException $e) {
    echo "\n❌ Migration failed: " . $e->getMessage() . "\n";
    echo "Error Code: " . $e->getCode() . "\n";
}
