<?php
// Migration: Add category limits to membership types
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/app/Core/Database.php';

try {
    $db = Core\Database::getInstance();
    
    echo "Adding category limits to membership types...\n\n";
    
    // Add category_limit column
    echo "1. Adding category_limit column...\n";
    $db->exec("ALTER TABLE membership_types ADD COLUMN IF NOT EXISTS category_limit INT DEFAULT NULL");
    echo "   ✓ Column added\n\n";
    
    // Set limits for each tier
    echo "2. Setting category limits:\n";
    
    $limits = [
        'Basic' => 2,
        'Silver' => 5,
        'Gold' => null  // null means unlimited
    ];
    
    $stmt = $db->prepare("UPDATE membership_types SET category_limit = ? WHERE LOWER(name) = ?");
    
    foreach ($limits as $name => $limit) {
        $stmt->execute([$limit, strtolower($name)]);
        $limitText = $limit === null ? 'Unlimited' : $limit;
        echo "   ✓ {$name}: {$limitText} categories\n";
    }
    
    echo "\n✅ Migration completed successfully!\n";
    echo "\nCategory limits:\n";
    echo "- Basic: 2 categories maximum\n";
    echo "- Silver: 5 categories maximum\n";
    echo "- Gold: Unlimited categories\n";
    
} catch (PDOException $e) {
    echo "\n❌ Migration failed: " . $e->getMessage() . "\n";
}
