<?php
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/app/Core/Database.php';

$db = \Core\Database::getInstance();

try {
    // Check if banner column already exists
    $stmt = $db->query("SHOW COLUMNS FROM companies LIKE 'banner'");
    if ($stmt->rowCount() > 0) {
        echo "✓ Banner column already exists.\n";
        exit;
    }
    
    // Add banner column
    $db->exec("ALTER TABLE companies ADD COLUMN banner VARCHAR(255) NULL COMMENT 'Banner image path'");
    
    echo "✅ Successfully added banner column to companies table!\n";
    
} catch (PDOException $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
    exit(1);
}
