<?php
require_once __DIR__ . "/config/config.php";
require_once __DIR__ . "/app/Core/Database.php";

use Core\Database;

try {
    $db = Database::getInstance();
    
    echo "Creating activities table...\n";
    
    // Create activities table
    $db->exec("CREATE TABLE IF NOT EXISTS activities (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id INT NULL,
        action VARCHAR(255) NOT NULL,
        details TEXT NULL,
        icon VARCHAR(10) DEFAULT '🔔',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE SET NULL
    )");
    
    echo "✅ Activities table created successfully!\n";
    
    // Add some sample activities if table is empty
    $count = $db->query("SELECT COUNT(*) FROM activities")->fetchColumn();
    if ($count == 0) {
        echo "\nAdding sample activities...\n";
        $db->exec("INSERT INTO activities (user_id, action, details, icon) VALUES 
            (1, 'System Started', 'Platform initialized successfully', '🚀'),
            (1, 'Database Setup', 'All tables created and configured', '💾'),
            (1, 'Activity Feed', 'Activity logging system is now operational', '📊')
        ");
        echo "✅ Sample activities added!\n";
    }
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}
