<?php
namespace Models;

class ProductType {
    public static function getAll() {
        $db = \Core\Database::getInstance();
        $stmt = $db->query("
            SELECT t1.*, t2.name as parent_name 
            FROM product_types t1
            LEFT JOIN product_types t2 ON t1.parent_id = t2.id
            ORDER BY t1.parent_id ASC, t1.name ASC
        ");
        return $stmt->fetchAll();
    }

    public static function find($id) {
        $db = \Core\Database::getInstance();
        $stmt = $db->prepare("SELECT * FROM product_types WHERE id = ? OR uuid = ?");
        $stmt->execute([$id, $id]);
        return $stmt->fetch();
    }

    public static function create($data) {
        $db = \Core\Database::getInstance();
        $stmt = $db->prepare("INSERT INTO product_types (name, description, parent_id) VALUES (?, ?, ?)");
        $parentId = !empty($data['parent_id']) ? $data['parent_id'] : null;
        return $stmt->execute([$data['name'], $data['description'], $parentId]);
    }

    public static function update($id, $data) {
        $db = \Core\Database::getInstance();
        $stmt = $db->prepare("UPDATE product_types SET name = ?, description = ?, parent_id = ? WHERE id = ?");
        $parentId = !empty($data['parent_id']) ? $data['parent_id'] : null;
        return $stmt->execute([$data['name'], $data['description'], $parentId, $id]);
    }

    public static function delete($id) {
        $db = \Core\Database::getInstance();
        $stmt = $db->prepare("DELETE FROM product_types WHERE id = ?");
        return $stmt->execute([$id]);
    }

    public static function getAllMapped() {
        $db = \Core\Database::getInstance();
        $stmt = $db->query("SELECT * FROM product_types");
        $results = $stmt->fetchAll();
        $map = [];
        foreach ($results as $row) {
            $map[$row['id']] = $row;
        }
        return $map;
    }

    public static function getTree($parentId = null, $depth = 0) {
        $db = \Core\Database::getInstance();
        $stmt = $db->prepare("SELECT * FROM product_types WHERE parent_id " . ($parentId === null ? "IS NULL" : "= ?") . " ORDER BY name ASC");
        
        if ($parentId === null) {
            $stmt->execute();
        } else {
            $stmt->execute([$parentId]);
        }
        
        $categories = $stmt->fetchAll();
        $tree = [];
        
        foreach ($categories as $cat) {
            $cat['depth'] = $depth;
            $tree[] = $cat;
            $children = self::getTree($cat['id'], $depth + 1);
            $tree = array_merge($tree, $children);
        }
        
        return $tree;
    }

    public static function getCategoryPath($id, $map) {
        $path = [];
        $currentId = $id;
        $visited = []; // Circular protection
        while (isset($map[$currentId]) && !isset($visited[$currentId])) {
            $visited[$currentId] = true;
            array_unshift($path, $map[$currentId]['name']);
            $currentId = $map[$currentId]['parent_id'];
        }
        return implode(' <i class="fa-solid fa-angle-right" style="font-size: 0.7rem; margin: 0 0.3rem; opacity: 0.5;"></i> ', $path);
    }
}
