<?php
namespace Models;

class Company {
    public static function getAll() {
        $db = \Core\Database::getInstance();
        $stmt = $db->query("
            SELECT c.*, 
                   COUNT(p.id) as product_count,
                   mt.name as membership_type_name,
                   mt.id as membership_type_id
            FROM companies c
            LEFT JOIN products p ON c.uuid = p.company_id AND p.deleted_at IS NULL
            LEFT JOIN membership_types mt ON c.membership_type_id = mt.id
            GROUP BY c.id
            ORDER BY c.created_at DESC
        ");
        return $stmt->fetchAll();
    }

    public static function find($id) {
        $db = \Core\Database::getInstance();
        $stmt = $db->prepare("
            SELECT c.*, 
                   mt.name as membership_type_name,
                   mt.id as membership_type_id
            FROM companies c
            LEFT JOIN membership_types mt ON c.membership_type_id = mt.id
            WHERE c.id = ?
        ");
        $stmt->execute([$id]);
        return $stmt->fetch();
    }

    public static function create($data) {
        $db = \Core\Database::getInstance();
        $sql = "INSERT INTO companies (name, email, phone, address, type, logo, banner, status, membership_type_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt = $db->prepare($sql);
        return $stmt->execute([
            $data['name'], 
            $data['email'], 
            $data['phone'], 
            $data['address'], 
            $data['type'], 
            $data['logo'] ?? null,
            $data['banner'] ?? null, 
            $data['status'] ?? 'active',
            $data['membership_type_id'] ?? null
        ]);
    }

    public static function update($id, $data) {
        $db = \Core\Database::getInstance();
        $sql = "UPDATE companies SET name = ?, email = ?, phone = ?, address = ?, type = ?, logo = ?, banner = ?, status = ?, membership_type_id = ? WHERE id = ?";
        $stmt = $db->prepare($sql);
        return $stmt->execute([
            $data['name'], 
            $data['email'], 
            $data['phone'], 
            $data['address'], 
            $data['type'], 
            $data['logo'] ?? null,
            $data['banner'] ?? null, 
            $data['status'],
            $data['membership_type_id'] ?? null,
            $id
        ]);
    }

    public static function count($status = null) {
        $db = \Core\Database::getInstance();
        $sql = "SELECT COUNT(*) FROM companies";
        if ($status) {
            $stmt = $db->prepare($sql . " WHERE status = ?");
            $stmt->execute([$status]);
        } else {
            $stmt = $db->query($sql);
        }
        return $stmt->fetchColumn();
    }

    public static function delete($id) {
        $db = \Core\Database::getInstance();
        $stmt = $db->prepare("DELETE FROM companies WHERE id = ?");
        return $stmt->execute([$id]);
    }

    public static function getProductTypes($companyId) {
        $db = \Core\Database::getInstance();
        $stmt = $db->prepare("
            SELECT pt.* 
            FROM product_types pt
            JOIN company_product_types cpt ON pt.id = cpt.product_type_id
            WHERE cpt.company_id = ?
        ");
        $stmt->execute([$companyId]);
        return $stmt->fetchAll();
    }

    public static function syncProductTypes($companyId, $typeIds) {
        $db = \Core\Database::getInstance();
        $db->beginTransaction();
        try {
            // Remove old ones
            $db->prepare("DELETE FROM company_product_types WHERE company_id = ?")->execute([$companyId]);
            
            // Add new ones
            if (!empty($typeIds)) {
                $stmt = $db->prepare("INSERT INTO company_product_types (company_id, product_type_id) VALUES (?, ?)");
                foreach ($typeIds as $typeId) {
                    $stmt->execute([$companyId, $typeId]);
                }
            }
            $db->commit();
            return true;
        } catch (\Exception $e) {
            $db->rollBack();
            return false;
        }
    }
}
