<?php
namespace Models;

class Brand {
    public static function getAll() {
        $db = \Core\Database::getInstance();
        $stmt = $db->query("SELECT * FROM brands ORDER BY name ASC");
        return $stmt->fetchAll();
    }

    public static function find($id) {
        $db = \Core\Database::getInstance();
        $stmt = $db->prepare("SELECT * FROM brands WHERE id = ? OR uuid = ?");
        $stmt->execute([$id, $id]);
        return $stmt->fetch();
    }

    public static function create($data) {
        $db = \Core\Database::getInstance();
        $slug = !empty($data['brand_slug']) ? $data['brand_slug'] : self::slugify($data['name']);
        $stmt = $db->prepare("INSERT INTO brands (name, brand_slug, country_of_origin, logo, description) VALUES (?, ?, ?, ?, ?)");
        return $stmt->execute([
            $data['name'], 
            $slug,
            $data['country_of_origin'] ?? null,
            $data['logo'] ?? null, 
            $data['description'] ?? null
        ]);
    }

    public static function update($id, $data) {
        $db = \Core\Database::getInstance();
        $slug = !empty($data['brand_slug']) ? $data['brand_slug'] : self::slugify($data['name']);
        $stmt = $db->prepare("UPDATE brands SET name = ?, brand_slug = ?, country_of_origin = ?, logo = ?, description = ? WHERE id = ?");
        return $stmt->execute([
            $data['name'], 
            $slug,
            $data['country_of_origin'] ?? null,
            $data['logo'] ?? null, 
            $data['description'] ?? null, 
            $id
        ]);
    }

    private static function slugify($text) {
        $text = preg_replace('~[^\pL\d]+~u', '-', $text);
        $text = iconv('utf-8', 'us-ascii//TRANSLIT', $text);
        $text = preg_replace('~[^-\w]+~', '', $text);
        $text = trim($text, '-');
        $text = preg_replace('~-+~', '-', $text);
        $text = strtolower($text);
        if (empty($text)) return 'n-a';
        return $text;
    }

    public static function delete($id) {
        $db = \Core\Database::getInstance();
        $stmt = $db->prepare("DELETE FROM brands WHERE id = ?");
        return $stmt->execute([$id]);
    }
}
