<?php
namespace Core;

class Auth {
    public static function start() {
        if (session_status() == PHP_SESSION_NONE) {
            session_start();
        }
    }

    public static function login($user) {
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['user_uuid'] = $user['uuid'];
        $_SESSION['role'] = $user['role'];
        $_SESSION['company_id'] = $user['company_id'] ?? null;
        $_SESSION['company_uuid'] = null;
        
        if ($user['company_id']) {
            $db = \Core\Database::getInstance();
            $stmt = $db->prepare("SELECT uuid FROM companies WHERE id = ?");
            $stmt->execute([$user['company_id']]);
            $_SESSION['company_uuid'] = $stmt->fetchColumn();
        }

        $_SESSION['company_name'] = $user['company_name'] ?? null;
        $_SESSION['name'] = $user['name'];
    }

    public static function logout() {
        session_destroy();
        header('Location: ?route=login');
    }

    public static function check($roles = null) {
        if (!isset($_SESSION['user_id'])) {
            header('Location: ?route=login');
            exit;
        }

        if ($roles) {
            if (is_array($roles)) {
                if (!in_array($_SESSION['role'], $roles)) {
                    die('Access Denied: Insufficient Permissions');
                }
            } else {
                if ($_SESSION['role'] !== $roles) {
                    die('Access Denied: Insufficient Permissions');
                }
            }
        }
    }

    public static function user() {
        return $_SESSION ?? null;
    }
}
